//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Reg
{
    //+----------------+
    private:
    //+----------------+
        string  h_value;
        uint    k_value;
    //+----------------+
    public:
    //+----------------+
        void Set(const uint arg1, const string arg2)
        {
            k_value = arg1;
            h_value = arg2;
        }
    //+----------------+
        uint Get_K(void)    { return k_value; }
    //+----------------+
        string Get_H(void)  { return h_value; }
    //+----------------+
};
//+----------------+
template <typename T>
struct st_Data
{
    //+----------------+
    private:
    //+----------------+
        T Values[];
    //+----------------+
    public:
    //+----------------+
        bool Set(const T &arg)
        {
            if (ArrayResize(Values, Values.Size() + (Values.Size() == 0 ? 2 : 1)) == INVALID_HANDLE)
                return false;

            Values[Values.Size() - 1] = arg;

            return true;
        }
    //+----------------+
        T Get(const uint index)
        {
            for (uint c = 0; c < Values.Size(); c++)
                if (Values[c].Get_K() == index)
                    return Values[c];

            return Values[0];
        }
    //+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => [", X, "]")
//+------------------------------------------------------------------+
void OnStart(void)
{
    const string T = "possible loss of data due to type conversion";
    const uint   K[] = {2, 1, 4, 0, 7, 5, 3, 6};

    st_Data <st_Reg> Info_1;
    string H[];

    StringSplit(T, ' ', H);
    for (uint c = 0; c < H.Size(); c++)
    {
        st_Reg  reg;

        reg.Set(K[c], H[c]);
        Info_1.Set(reg);
    }

    PrintX(Info_1.Get(3).Get_H());
    PrintX(Info_1.Get(13).Get_H());
}
//+------------------------------------------------------------------+